#include <iostream>
#include <vector>

using namespace std;

const int N = 100;

bool query(int x, int y) {
  if (y <= 0 || x > N || y <= 0 || y > N) return false;
  cout << "? " << x << " " << y << endl;
  cout.flush();
  string ans;
  cin >> ans;
  if (ans == "inside")
    return true;
  return false;
}


bool square() {
  bool S[5][5];
  for (int i = 0; i < 4; i++) 
    for (int j = 0; j < 4; j++) 
      S[i][j] = query((i + 1) * 20, (j + 1) * 20);
	
  bool found = 0;
  for (int i = 0; i < 4; i++) 
    for (int j = 0; j < 4; j++) 
      found = max(found, S[i][j]);
	
  if (!found) {
    for (int i = 0; i < 5; i++) 
      S[i][4] = query((i + 1) * 20, 100);

    for (int i = 0; i < 4; i++) 
      S[4][i] = query(100, (i + 1) * 20);

    for (int i = 0; i < 5; i++) 
      for (int j = 0; j < 5; j++) 
        found = max(found, S[i][j]);
  
    if (!found) 
      return false;
  
    vector< pair<int, int> > founds;
    for (int i = 0; i < 5; i++) 
      for (int j = 0; j < 5; j++) 
        if (S[i][j]) 
          founds.push_back(make_pair(i, j));
  
    if (founds.size() > 1) 
      return false;
  
    int x = founds[0].first, y = founds[0].second;
    if (x == 4) {
      int bot = y * 20;
      int top = (y + 1) * 20;
      int mid;
      while (bot + 1 < top) {
        mid = (bot + top) / 2;
        if (query(100, mid)) 
          top = mid;
        else 
          bot = mid;
      }
      int left_edge = bot + 1;
      if (query(100, left_edge + 19) && !query(100, left_edge + 20)) 
        return true;
      else 
        return false;
    } else {
      int bot = x * 20;
      int top = (x + 1) * 20;
      int mid;
      while (bot + 1 < top) {
        mid = (bot + top) / 2;
        if (query(mid, 100)) 
          top = mid;
	else 
          bot = mid;
      }
      int top_edge = bot + 1;
      if (query(top_edge + 19, 100) && !query(top_edge + 20, 100)) 
        return true;
      else 
        return false;
    }
  } else {
    int minx = 100;
    int miny = 100;
    int maxx = 0;
    int maxy = 0;
    for (int i = 0; i < 4; i++) {
      for (int j = 0; j < 4; j++) {
        if (S[i][j]) {
          minx = min(minx, i);
          miny = min(miny, j);
          maxx = max(maxx, i);
          maxy = max(maxy, j);
        }
      }
    }

    int bot = minx * 20;
    int top = (minx + 1) * 20;
    int  mid;
    while (bot + 1 < top) {
      mid = (bot + top) / 2;
      if (query(mid, (miny + 1) * 20)) 
        top = mid;
      else 
        bot = mid;
    }

    int top_edge = bot + 1;
    bot = (maxx + 1) * 20;
    top = (maxx + 2) * 20 + 1;
    while (bot + 1 < top) {
      mid = (bot + top) / 2;
      if (query(mid, (miny + 1) * 20)) 
        bot = mid;
      else 
        top = mid;
    }

    int bottom_edge = bot;
    bot = miny * 20;
    top = (miny + 1) * 20;
    while (bot + 1 < top) {
      mid = (bot + top) / 2;
      if (query((minx + 1) * 20, mid)) 
        top = mid;
      else 
        bot = mid;
    }

    int left_edge = bot + 1;
    int sze = bottom_edge - top_edge;
    int right_bound = left_edge + sze;
    if (query((minx + 1) * 20, right_bound) && !query((minx + 1) * 20, right_bound + 1)) 
      return true;
    else 
      return false;
  }
}

int main() {
  bool res = square();
  if (res)
    cout << "! square" << endl;
  else 
    cout << "! rectangle" << endl;
  cout.flush();
  return 0;
}
