// #pragma GCC optimize("-Ofast")
#include <bits/stdc++.h>

#define pb push_back
#define all(x) (x).begin(), (x).end()
#define sz(x) (int)(x).size()

using namespace std;

typedef long long ll;

const int MAXN = (int)1e5 + 5;
const int K = 300;
const int I = MAXN / K + 2;

int P[I][MAXN], Q[I][I];
ll S[MAXN], T[MAXN];
ll a[MAXN], b[I];
int p[MAXN];
int n, m, q;

void sqrtUpdI(int p, ll x) {
	S[p] += x;
	T[p / K] += x;
}

void sqrtUpd(int id, int l, int r, int x) {
	int cl = l / K, cr = r / K;

	if (cl == cr) {
		for (int i = l; i <= r; i++) {
			P[id][i] += x;
		}

		return;
	}

	for (int i = l, j = (cl + 1) * K; i < j; i++) {
		P[id][i] += x;
	}

	for (int i = cl + 1; i < cr; i++) {
		Q[id][i] += x;
	}

	for (int i = cr * K; i <= r; i++) {
		P[id][i] += x;
	}
}

ll sqrtGetI(int l, int r) {
	int cl = l / K, cr = r / K;
	ll ret = 0;

	if (cl == cr) {
		for (int i = l; i <= r; i++) {
			ret += S[i];
		}

		return ret;
	}

	for (int i = l, j = (cl + 1) * K; i < j; i++) {
		ret += S[i];
	}

	for (int i = cl + 1; i < cr; i++) {
		ret += T[i];
	}

	for (int i = cr * K; i <= r; i++) {
		ret += S[i];
	}

	return ret;
}

int sqrtGet(int id, int p) {
	return P[id][p] + Q[id][p / K];
}

int sqrtGet(int id, int l, int r) {
	return sqrtGet(id, r) - (l ? sqrtGet(id, l - 1) : 0);
}

void build() {
	for (int i = 0; i * K < n; i++) {
		int l = i * K, r = min(n, (i + 1) * K);

		for (int j = l; j < r; j++) {
			int x = p[j];
			int id = x / K;
			++P[i][x];
			--P[i][min(n, (id + 1) * K)];
			++Q[i][id + 1];
		}

		for (int j = 1; j < n; j++) {
			P[i][j] += P[i][j - 1];
		}

		for (int j = 1; j < I; j++) {
			Q[i][j] += Q[i][j - 1];
		}
	}
}

void update(int l, int r, int x) {
	int cl = l / K, cr = r / K;

	if (cl == cr) {
		for (int i = l; i <= r; i++) {
			sqrtUpdI(p[i], x);
		}

		return;
	}

	for (int i = l, j = (cl + 1) * K; i < j; i++) {
		sqrtUpdI(p[i], x);
	}
	
	for (int i = cl + 1; i < cr; i++) {
		b[i] += x;
	}

	for (int i = cr * K; i <= r; i++) {
		sqrtUpdI(p[i], x);
	}
}

ll query(int l, int r) {
	ll res = sqrtGetI(l, r);
	
	for (int i = 0; i < I; i++) {
		res += b[i] * sqrtGet(i, l, r);
	}

	return res;
}

void push(int t) {
	if (!b[t]) {
		return;
	}

	int l = t * K, r = min(n, (t + 1) * K);

	for (int i = l; i < r; i++) {
		sqrtUpdI(p[i], b[t]);
	}

	b[t] = 0;
}

void exchange(int a, int b) {
	int ca = a / K, cb = b / K;

	if (ca != cb) {
		push(ca);
		push(cb);

		if (p[a] < p[b]) {
			sqrtUpd(ca, p[a], p[b] - 1, -1);
			sqrtUpd(cb, p[a], p[b] - 1, 1);
		}
		else {
			sqrtUpd(ca, p[b], p[a] - 1, 1);
			sqrtUpd(cb, p[b], p[a] - 1, -1);
		}
	}

	swap(p[a], p[b]);
}

int main() {
	ios::sync_with_stdio(0);
	cin.tie(0);
	cin >> n >> q;

	for (int i = 0; i < n; i++) {
		cin >> p[i];
		p[i]--;
	}

	build();

	for (int i = 1; i <= q; i++) {
		int tp;
		cin >> tp;

		if (tp == 1) {
			int l, r, x;
			cin >> l >> r >> x;
			l--;
			r--;
			update(l, r, x);
		}
		else if (tp == 2) {
			int l, r;
			cin >> l >> r;
			l--;
			r--;
			cout << query(l, r) << '\n';
		}
		else {
			int a, b;
			cin >> a >> b;
			a--;
			b--;
			exchange(a, b);
		}
	}

	return 0;
}
