#include "testlib.h"
#include <algorithm>
#include <iostream>

using namespace std;
typedef long long ll;

static constexpr __int128_t MIN_V = -1e18;
static constexpr __int128_t MAX_V = 1e18;

int main(int argc, char* argv[]) {
    registerTestlibCmd(argc, argv);

    int N = inf.readInt();
    int subtask = inf.readInt();
    
    auto A1 = inf.readLongs(N);
    vector<__int128_t> A(A1.begin(), A1.end());

    int pans = ouf.readInt(0, 100, "Number of operations");
    // ouf.readEoln();

    for (int i = 0; i < pans; ++i) {
        int op = ouf.readInt(1, 3, "Operation type");
        if (op == 1) {
            for (int i = 0; i < N; i++) {
                A[i] = -A[i];
            }
        } else {
            // ouf.readSpace();
            int l = ouf.readInt(1, N, "l") - 1;
            // ouf.readSpace();
            int r = ouf.readInt(l, N, "r") - 1;
            if (op == 3)
                swap(l, r);
            if (l <= r) {
                for (int i = l + 1; i <= r; ++i) {
                    A[i] += A[i - 1];
                }
            } else {
                for (int i = l - 1; i >= r; --i) {
                    A[i] += A[i + 1];
                }
            }
            for (int i = 0; i < N; ++i) {
                A[i] = clamp(A[i], MIN_V, MAX_V);
            }
        }
        // ouf.readEoln();
    }
    // ouf.readEof();

    if (*min_element(A.begin(), A.end()) < 0) {
        quitf(_wa, "Invalid sequence of operations");
    }

    int jans = ans.readInt();
    if (pans < jans) {
        quitf(_fail, "Participant's answer is better than jury's");
    } else if ((subtask == 2 && pans <= 100)
                || (subtask == 3 && pans <= jans + 3)
                || (subtask == 4 && pans <= jans + 1)
                || (pans == jans)) {
        quitf(_ok, "OK: %d operations", pans);
    } else {
        quitf(_wa, "Too many operations");
    }

    return 0;
}
