#include "testlib.h"

using namespace std;

vector<int> items, places;

const int MAX_VALUE = 4;

int countSum(){
    vector<int> counter(MAX_VALUE);
    for (int i = 0; i < (int) items.size(); i++) {
        counter[places[i] - 1] += items[i];    
    }
    int ans = 0;
    for (int a : counter) {
        ans = max(ans, a);
    }
    return ans;
}

int readAns(InStream &in) {
    int p = in.readInt(-1, MAX_VALUE, "p");
    if (p == 0) {
        in.quitf(_wa, "zero present");
    }
    if (p == -1) {
        return countSum();
    }
    p--;
    places[p] = places[p] % 2 + 1;
    int sum = countSum();
    places[p] = places[p] % 2 + 1;
    return sum;
}

int main(int argc, char *argv[]) {
    registerTestlibCmd(argc, argv);

    items = inf.readInts(MAX_VALUE);
    places = inf.readInts(MAX_VALUE);
    
    int jury_answer = readAns(ans);
    int part_answer = readAns(ouf);
    
    if (jury_answer == part_answer) {
        quitf(_ok, "ok");
    }
    if (jury_answer > part_answer) {
        quitf(_fail, "participant's answer (%d) is better (%d)", part_answer, jury_answer);
    } else {
        quitf(_wa, "participant's answer (%d) is not good enough (%d)", part_answer, jury_answer);
    }
    
}