#include "testlib.h"
#include <vector>
#include <string>
#include <map>

using namespace std;

int main(int argc, char *argv[]) {
    registerValidation(argc, argv);

    int N = inf.readInt(1, 10'000, "n");
    inf.readEoln();

    map <int, int> map_of_ID, map_of_score;
    map_of_ID.clear(); map_of_score.clear();
    for (int i = 0; i < N; i++){
        // $ID$, $gender$, $class$, $age$, $score$
        int ID = inf.readInt(1'000'000, 9'999'999, "ID");
        ensuref(map_of_ID[ID] != 1, "All IDs should be different");
        map_of_ID[ID] = 1;
        inf.readSpace();
        string gender = inf.readToken("male|female", "gender");
        inf.readSpace();
        int cont_grade = inf.readInt(1, 11, "grade");
        inf.readSpace();
        int age = inf.readInt(10, 20, "age");
        inf.readSpace();
        int score = inf.readInt(0, 100'000'000, "score");
        inf.readEoln();
        ensuref(map_of_score[score] != 1, "All scores should be different");
        map_of_score[score] = 1;
    }
    int M = inf.readInt(1, 7, "m");
    inf.readEoln();
    set<string> olympiads;
    for (int i = 0; i < M; i++) {
        string olymp = inf.readToken("IOI|CEOI|EGOI|EJOI|BaltOI|BalkOI|JBOI", "olymp");
        inf.readEoln();
        olympiads.insert(olymp);
    }
    ensure((int) olympiads.size() == M);
    inf.readEof();
}
