#include <iostream>
#include <algorithm>
#include <numeric>
#include <vector>
#include <string.h>
 
using namespace std;
 
typedef long long ll;
 
struct node{
    ll mx;
    node *l,*r;
    node():mx(0),l(nullptr),r(nullptr){}
    node(ll x):mx(x),l(nullptr),r(nullptr){}
};
 
ll val(node* v){
    return v ? v->mx : 0ll;
}
 
node* upd(node* v,int l,int r,vector<pair<ll,int>> updates){
    if(l > r)
        return nullptr;
    node* u = new node();
    if(v){
        u->mx = v->mx;
        u->l = v->l;
        u->r = v->r;
    }
    if(l == r){
        for(auto&[val,pos] : updates){
            u->mx = max(u->mx,val);
        }
        return u;
    }
    int m = (l+r)>>1;
    vector<pair<ll,int>> l_updates, r_updates;
    for(auto&[val,pos] : updates){
        if(pos <= m)
            l_updates.push_back(make_pair(val,pos));
        else
            r_updates.push_back(make_pair(val,pos));
    }
 
    if(!l_updates.empty()){
        u->l = upd(u->l,l,m,l_updates);
    }
    if(!r_updates.empty()){
        u->r = upd(u->r,m+1,r,r_updates);
    }
    u->mx = max(val(u->l),val(u->r));
    return u;
}
 
ll get(node* v,int l,int r,int tl,int tr){
    if(!v || l > r || tl > tr) return 0;
    if(l == tl && r == tr)
        return v->mx;
    int m = (l+r)>>1;
    return max(get(v->l,l,m,tl,min(tr,m)),get(v->r,m+1,r,max(tl,m+1),tr));
}
 
int main(){
    ios::sync_with_stdio(false);cin.tie(nullptr);cout.tie(nullptr);
    int n,q;
    cin >> n >> q;
 
    int a[n+1];
    for(int i = 1; i <= n; i++){
        cin >> a[i];
    }
    long long pref[n+1];
    memset(pref,0,sizeof pref);
    for(int i = 1; i <= n; i++){
        pref[i] = a[i] + pref[i-1];
    }
 
    vector<pair<int,int>> gcd_changes[n+1];
    vector<pair<int,int>> gcd_changesR[n+2];
 
    for(int i = 1; i <= n; i++){
        gcd_changes[i].push_back(make_pair(a[i],i));
        for(auto&[val,pos] : gcd_changes[i-1]){
            int g = gcd(val,gcd_changes[i].back().first);
            if(g != gcd_changes[i].back().first){
                gcd_changes[i].push_back(make_pair(g,pos));
            } else {
                gcd_changes[i].back().second = pos;
            }
        }
    } /// this should be O(NlogA) if I did not blunder
 
    for(int i = n; i >= 1; i--){
        gcd_changesR[i].push_back(make_pair(a[i],i));
        for(auto&[val,pos] : gcd_changesR[i+1]){
            int g = gcd(val,gcd_changesR[i].back().first);
            if(g != gcd_changesR[i].back().first){
                gcd_changesR[i].push_back(make_pair(g,pos));
            } else {
                gcd_changesR[i].back().second = pos;
            }
        }
    } /// this should be O(NlogA) if I did not blunder
 
    node* root[n+1];
    root[0] = new node();
 
 
    for(int i = 1; i <= n; i++){
        vector<pair<ll,int>> to_update;
        for(auto&[val,pos] : gcd_changes[i]){
            // cerr << "i,val,pos: " << i << " " << val << " " << pos << "\n";
            to_update.push_back(make_pair(1ll*(pref[i]-pref[pos-1])*val,pos));
        }
        root[i] = upd(root[i-1],1,n,to_update);
        // What is time complexity of this
    }
 
    while(q--){
        int l,r;
        cin >> l >> r;
        ll ans = get(root[r],1,n,l,r);
        // cerr << "l,r: " << l << " " << r << "\n";
        for(auto&[val,pos] : gcd_changesR[l]){
            int tr = min(pos,r);
            // cerr << "val,tr: " << val << " " << tr << "\n";
            ans = max(ans,1ll*(pref[tr]-pref[l-1])*val);
        }
        cout << ans << "\n";
    }
 
    return 0;
}
