#include<bits/stdc++.h>
#define all(x) begin(x), end(x)
using namespace std;
using ll = long long;
struct Fenwick {
    vector<ll> f;
    Fenwick(int N) : f(N+1) {}
    void upd(int p, ll v) {
        for(; p; p -= p&-p)
            f[p] = max(f[p], v);
    }
    ll qry(int p) {
        ll r = 0;
        for(; p < f.size(); p += p&-p)
            r = max(r, f[p]);
        return r;
    }
};
int main() {
    cin.tie(0)->sync_with_stdio(0);
    int n, q;
    cin >> n >> q;
    vector<ll> a(n), ans(q), pref {0};
    vector<vector<array<int, 2>>> Qs(n);
    for(auto &i : a) cin >> i;
    for(int l, r, i = 0; i < q; i++) {
        cin >> l >> r;
        Qs[r - 1].push_back({l, i});
    }
    for(auto i : a) pref.push_back(pref.back() + i);
    auto get_jumps = [&]() {
        vector<array<int, 2>> cur;
        vector<decltype(cur)> jumps;
        for(auto i : a) {
            cur.push_back({i, 0});
            decltype(cur) nxt;
            int lst = -1;
            for(auto &[g, l] : cur) {
                g = __gcd<int>(g, i); l++;
                if(g != lst) {
                    nxt.push_back({g, l});
                }
                lst = g;
            }
            jumps.push_back(cur = nxt);
        }
        return jumps;
    };
    auto Rjmp = get_jumps();
    reverse(all(a));
    auto Ljmp = get_jumps();
    reverse(all(Ljmp));
    Fenwick f(n);
    for(int i = 0; i < n; i++) {
        for(auto [g, l] : Rjmp[i]) {
            ll su = pref[i + 1] - pref[i + 1 - l];
            su *= g;
            // cout << i + 1 << " " << l << " " << su << endl;
            f.upd(i + 1 - l, su);
        }
        for(auto [l, id] : Qs[i]) {
            // cout << id << endl;
            // cout << "ask " << l << endl;
            ans[id] = f.qry(l);
            for(auto [g, len] : Ljmp[l - 1]) {
                int R = min(l + len - 1, i + 1);
                ll su = pref[R] - pref[l - 1];
                // cout << len << " " << su << " " << g << endl;
                ans[id] = max(ans[id], su * g);
            }
        }
    }
    for(auto i : ans) cout << i << '\n';
}