#include <algorithm>
#include <iostream>
#include <numeric>
#include <vector>

const int N = 2e5 + 1, LOG = 18;
using namespace std;
typedef pair<int, int> pi;

long long pr[N + 1];

long long getsum(int l, int r){
    if(l > r) return 0;
    return pr[r + 1] - pr[l];
}

struct q_node{
    //vector of -> new gcd, position
    vector<pi> l_dgcd, r_dgcd;
    long long bst = -1;
    q_node(){}
    q_node(int val, int pos){
        l_dgcd.push_back({val, pos});
        r_dgcd.push_back({val, pos});
        bst = val * 1ll * val;
    }
};

class q_sub_best{
    q_node tr[N * LOG];
    q_node comb(q_node l, q_node r, int pl, int pr){
        if(l.bst == -1) return r;
        if(r.bst == -1) return l;
        q_node rs;
        rs.bst = max(l.bst, r.bst);

        int pr_gcd1 = 0, pr_gcd2 = 0;
        l.r_dgcd.push_back({0, pl - 1});
        r.l_dgcd.push_back({0, pr + 1});
        for(auto [gcd1, lp]: l.r_dgcd){
            swap(gcd1, pr_gcd1);
            lp += 1;
            pr_gcd2 = 0;
            for(auto [gcd2, rp]: r.l_dgcd){
                swap(gcd2, pr_gcd2);
                rp -= 1;
                rs.bst = max(rs.bst, getsum(lp, rp) * gcd(gcd1, gcd2));
            }
        }
        l.r_dgcd.pop_back();
        r.l_dgcd.pop_back();
        int pgcd;
        rs.l_dgcd = vector(l.l_dgcd); 
        if(!l.l_dgcd.empty())
            pgcd = l.l_dgcd.back().first;
        else pgcd = 0;
        for(auto [val, pos]: r.l_dgcd){
            if(pgcd == gcd(pgcd, val)) continue;
            pgcd = gcd(pgcd, val);
            rs.l_dgcd.push_back({pgcd, pos});
        }
        rs.r_dgcd = vector(r.r_dgcd);
        if(!r.r_dgcd.empty())
            pgcd = r.r_dgcd.back().first;
        else pgcd = 0;
        for(auto [val, pos]: l.r_dgcd){
            if(pgcd == gcd(pgcd, val)) continue;
            pgcd = gcd(pgcd, val);
            rs.r_dgcd.push_back({pgcd, pos});
        }
        return rs;
    }
public:
    void build(int v, int l, int r, int a[]){
        if(l == r){
            tr[v] = q_node(a[l], l);
            return;
        }
        int m = (l + r) >> 1;
        build(v << 1, l, m, a);
        build(v << 1 | 1, m + 1, r, a);
        tr[v] = comb(tr[v << 1], tr[v << 1 | 1], l, r);
    }
    q_node get(int v, int l, int r, int ql, int qr){
        if(ql > qr) return q_node();
        if(ql == l && qr == r){
            // cout << "pr.l..r: " << tr[v].l << ".." << tr[v].r << ", l..r: " << l << ".." << r << endl;
            return tr[v];
        }
        int m = (l + r) >> 1;
        q_node k = comb(
            get(v << 1, l, m, ql, min(qr, m)),
            get(v << 1 | 1, m + 1, r, max(ql, m + 1), qr),
            ql, qr
        );
        return k;
    }
};

int main(){
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    int n, q, a[N];
    cin >> n >> q;
    pr[0] = 0;
    for(int i = 0; i < n; ++i)
        cin >> a[i], pr[i + 1] = pr[i] + a[i];
    q_sub_best qb;
    qb.build(1, 0, n - 1, a);
    for(int i = 0; i < q; ++i){
        int l, r;
        cin >> l >> r; --l; --r;
        cout << qb.get(1, 0, n - 1, l, r).bst << '\n';
        // auto [ls, rs, bst, dl, dr] = qb.get(1, 0, n - 1, l, r);
        // cout << i << ") ";
        // cout << getsum(l, r) << ' ';
        // cout << "ls: ";
        // for(auto [gcd, pos]: ls)
        //     cout << "{" << gcd << ", " << pos << "} ";
        // cout << ", rs: ";
        // for(auto [gcd, pos]: rs)
        //     cout << "{" << gcd << ", " << pos << "} ";
        // cout << '\n';
    }
    return 0;
}