#include <iostream>
#include <vector>
#include <queue>

using namespace std;

int main(){
    ios::sync_with_stdio(false);cin.tie(nullptr);cout.tie(nullptr);
    int n,m;
    cin >> n >> m;
    char g[n][m];
    
    vector<pair<int,int>> holes;
    
    for(int i = 0; i < n; i++){
        string s;
        cin >> s;
        for(int j = 0; j < m; j++){
            g[i][j] = s[j];
            if(g[i][j] == 'H'){
                holes.push_back(make_pair(i,j));
            }
        }
    }
    
    int mx_dist[n][m];
    for(int i = 0; i < n; i++){
        for(int j = 0; j < m; j++){
            mx_dist[i][j] = 0;
            if(g[i][j] == 'F')
                mx_dist[i][j] = (int)1e9;
        }
    }
    
    int d[n][m];
    
    int dx[] = {1,0,-1,0};
    int dy[] = {0,1,0,-1};
    
    for(auto&[sx,sy] : holes){
        for(int i = 0; i < n; i++){
            for(int j = 0; j < m; j++){
                d[i][j] = (int)1e9;
            }
        }
        queue<pair<int,int>> q;
        q.push(make_pair(sx,sy));
        d[sx][sy] = 0;
        while(!q.empty()){
            int x = q.front().first, y = q.front().second;
            q.pop();
            mx_dist[x][y] = max(mx_dist[x][y],d[x][y]);
            for(int i = 0; i < 4; i++){
                int xn = x + dx[i], yn = y + dy[i];
                if(xn >= 0 && xn < n && yn >= 0 && yn < m && g[xn][yn] != 'F' && d[xn][yn] > d[x][y] + 1){
                    d[xn][yn] = d[x][y] + 1;
                    q.push(make_pair(xn,yn));
                }
            }
        }
    }
    int mn = (int)1e9;
    int cnt = 0;
    for(int i = 0; i < n; i++){
        for(int j = 0; j < m; j++){
            if(mn > mx_dist[i][j]){
                mn = mx_dist[i][j];
                cnt = 1;
            } else if(mn == mx_dist[i][j]){
                cnt++;
            }
        }
    }
    cout << cnt << "\n";
    for(int i = 0; i < n; i++){
        for(int j = 0; j < m; j++){
            if(mn == mx_dist[i][j]){
                cout << i+1 << " " << j+1 << "\n";
            }
        }
    }
    return 0;
}