#include "testlib.h"
#include <iostream>
#include <vector>
#include <algorithm>
#include <queue>
// #include <ext/pb_ds/tree_policy.hpp>
// #include <ext/pb_ds/assoc_container.hpp>
 
// constexpr int MAX_N = 1'000'000;
// constexpr int MAX_A = (int)1e9;

constexpr int N_MAX = (int)1e6;
constexpr int K_MAX = (int)1e9;

const int MAX_N[] = {
	N_MAX, // sample
	N_MAX,
	N_MAX,
	2000,
	2000,
	N_MAX,
	N_MAX
};

const int MAX_K[] = {
	K_MAX, // sample
	1,
	K_MAX,
	2000,
	K_MAX,
	K_MAX,
	K_MAX
};

const bool one_cycle[] = {
	false, // sample
	false,
	false,
	false,
	true,
	true,
	false
};

const bool id[] = {
	false, // sample
	false,
	true,
	false,
	false,
	false,
	false
};

signed main(int argc,char* argv[]){
	registerGen(argc,argv,1);
 
	int group = atoi(argv[1]);
	int n = rnd.next(1,MAX_N[group]);
	int k = rnd.next(1,MAX_K[group]);
	if(argc > 2 && atoi(argv[2]) > 0)
		n = atoi(argv[2]);
	if(argc > 3 && atoi(argv[3]) > 0)
		k = atoi(argv[3]);

	std::cout << n << " " << k << "\n";

	std::vector<int> p = rnd.perm(n);

	if(one_cycle[group]){
		std::vector<int> perm = rnd.perm(n);
		for(int i = 1; i < n; i++){
			p[perm[i-1]] = perm[i];
		}
		p[perm[n-1]] = perm[0];
	}

	if(id[group]){
		for(int i = 0; i < n; i++)
			p[i] = i;
	}

	for(int i = 0; i < n; i++){
		std::cout << p[i] + 1;
		if(i != n-1)
			std::cout << " ";
	}
	std::cout << "\n";

	return 0;
}