#include "testlib.h"
#include <bits/stdc++.h>
using namespace std;
 
constexpr int MAX_N = 1'000'000;
constexpr int MAX_K = (int)1e9;

bool is_perm(int n,int* p){
	bool was[n+1];
	memset(was,0,sizeof was);
	for(int i = 1; i <= n; i++){
		if(was[p[i]])
			return false;
		was[p[i]] = true;
	}
	return true;
}

int main(int argc,char* argv[]){
	registerValidation(argc,argv);

	bool one_cycle = false;
	bool pi_eq_i = false;
	
	int N = MAX_N;
	int K = MAX_K;
 
 	switch(atoi(validator.group().c_str())){
        // case 0: MAX_N = 10, MAX_C = 5, MAX_Q = 20; break;
        case 1: K = 1; break;
        case 2: pi_eq_i = true; break;
        case 3: N = 2000; K = 2000; break;
        case 4: N = 2000; one_cycle = true; break;
        case 5: one_cycle = true; break;
        default: break;
    }
    
    

    int n = inf.readInt(1,N,"n");
    inf.readSpace();
    int k = inf.readInt(1,K,"k");
    inf.readEoln();

    int p[n+1];
    for(int i = 1; i <= n; i++){
    	p[i] = inf.readInt(1,n,"p_i");
    	if(i != n)
    		inf.readSpace();
    }
    inf.readEoln();
    inf.readEof();

    ensuref(is_perm(n,p),"is not a permutation");

    if(one_cycle){
    	int pos = 1;
    	set<int> s;
    	for (int i = 0; i < n; i++) {
    	    s.insert(pos);
    	    pos = p[pos];
    	}
    	ensure(pos == 1 && (int) s.size() == n);
    }
    
    if(pi_eq_i){
        for(int i = 1; i <= n; i++){
            ensure(p[i] == i);
        }
    }

 
	return 0;
}
