#include "testlib.h"
#include <iostream>
#include <vector>
#include <algorithm>
#include <queue>
#include <ext/pb_ds/tree_policy.hpp>
#include <ext/pb_ds/assoc_container.hpp>
 
// constexpr int MAX_N = 1'000'000;
// constexpr int MAX_A = (int)1e9;
 
constexpr int N_MAX = (int)1e6;

using namespace std;
using namespace __gnu_pbds;
 
const int MAX_N[] = {
	N_MAX, 	// sample
	3, 	// 1
	10, 	// 2
	5000, 	// 3
	N_MAX, 	// 4
	N_MAX, 	// 5
	100'000, 	// 6
	200'000, 	// 7
	N_MAX 	// 8
};

void random(int n,int m){
	vector<pair<int,int>> edges;
    cout << n << " " << m << "\n";
    if(1ll * n * (n-1)/2 <= (int)1e7){
        tree<pair<int,int>,null_type,less<pair<int,int>>,rb_tree_tag,tree_order_statistics_node_update> st;
        for(int i = 1; i <= n; i++){
            for(int j = i+1; j <= n; j++){
                st.insert(make_pair(i,j));
            }
        }
        for(int i = 0; i < m; i++){
            int sz = st.size();
            int pos = rnd.next(0,sz-1);
            pair<int,int> p = *st.find_by_order(pos);
            st.erase(p);
            edges.push_back(p);
        }
    } else {
        set<pair<int,int>> st;
        for(int i = 0; i < m; i++){
            int a = rnd.next(1,n);
            int b = a;
            if(a > b)
                swap(a,b);
            while(a == b || st.count(make_pair(a,b))){
                a = rnd.next(1,n);
                b = rnd.next(1,n);
                if(a > b)
                    swap(a,b);
            }
            st.insert(make_pair(a,b));
            edges.push_back(make_pair(a,b));
        }
    }
    shuffle(edges.begin(),edges.end());
    for(auto&[x,y] : edges){
        if(rnd.next(0,1))
            swap(x,y);
        cout << x << " " << y << "\n";
    }
    return;
}
 
signed main(int argc,char* argv[]){
	registerGen(argc,argv,1);
 
	int group = atoi(argv[1]);
	int n = MAX_N[group];
	int m = rnd.next(1ll,min(1ll*n*(n-1)/2,1ll*N_MAX));
	
	if(group == 3)
	    m = rnd.next(1ll,min(1ll*n*(n-1)/2,1ll*5000));

	if(group == 4){
		random(n,m);
        return 0;
	}

	if(group == 5){
		int cnt[n+1];
		memset(cnt,0,sizeof cnt);
		m = 0;
		vector<pair<int,int>> edges;
		for(int i = 1; i < n; i++){
			int x = rnd.next(cnt[i],10);
			set<int> st;
			while(cnt[i] < x && m < N_MAX){
				int j = rnd.next(i+1,n);
				if(cnt[j] == 10 || st.count(j))
					break;
				m++;
				st.insert(j);
				cnt[j]++;
				cnt[i]++;
				edges.push_back(make_pair(i,j));
			}
		}
		cout << n << " " << m << "\n";
		for(auto&[x,y] : edges){
		    cout << x << " " << y << "\n";
		}
		return 0;
	}

	random(n,m);
	
 
	return 0;
}
/**
 * 
 * (x;y) = x*n + y-x = x*(n-1) + y
**/
