#include "testlib.h"
#include <iostream>
#include <vector>
#include <algorithm>
#include <queue>
#include <ext/pb_ds/tree_policy.hpp>
#include <ext/pb_ds/assoc_container.hpp>
 
// constexpr int MAX_N = 1'000'000;
// constexpr int MAX_A = (int)1e9;
 
constexpr int N_MAX = (int)1e6;

using namespace std;
using namespace __gnu_pbds;
 
const int MAX_N[] = {
	N_MAX, 	// sample
	3, 	// 1
	10, 	// 2
	5000, 	// 3
	N_MAX, 	// 4
	N_MAX, 	// 5
	100'000, 	// 6
	200'000, 	// 7
	N_MAX 	// 8
};

vector<pair<int,int>> random(int n,int m){
	vector<pair<int,int>> edges;
    cout << n << " " << m << "\n";
    if(1ll * n * (n-1)/2 <= (int)1e7){
        tree<pair<int,int>,null_type,less<pair<int,int>>,rb_tree_tag,tree_order_statistics_node_update> st;
        for(int i = 1; i <= n; i++){
            for(int j = i+1; j <= n; j++){
                st.insert(make_pair(i,j));
            }
        }
        for(int i = 0; i < m; i++){
            int sz = st.size();
            int pos = rnd.next(0,sz-1);
            pair<int,int> p = *st.find_by_order(pos);
            st.erase(p);
            edges.push_back(p);
        }
    } else {
        set<pair<int,int>> st;
        for(int i = 0; i < m; i++){
            int a = rnd.next(1,n);
            int b = a;
            if(a > b)
                swap(a,b);
            while(a == b || st.count(make_pair(a,b))){
                a = rnd.next(1,n);
                b = rnd.next(1,n);
                if(a > b)
                    swap(a,b);
            }
            st.insert(make_pair(a,b));
            edges.push_back(make_pair(a,b));
        }
    }
    shuffle(edges.begin(),edges.end());
    for(auto&[x,y] : edges){
        if(rnd.next(0,1))
            swap(x,y);
    }
    return edges;
}

void add(set<pair<int,int>>& st,pair<int,int> p){
	st.insert(p);
	st.insert(make_pair(p.second,p.first));
	return;
}

signed main(int argc,char* argv[]){
	registerGen(argc,argv,1);
 
	int group = atoi(argv[1]);
	int n = MAX_N[group];
	int m = n-n%3;

	vector<int> p = rnd.perm(n-n%3);
	vector<pair<int,int>> edges;

	for(int i = 0; i < p.size(); i += 3){
		edges.push_back(make_pair(p[i],p[i+1]));
		edges.push_back(make_pair(p[i],p[i+2]));
		edges.push_back(make_pair(p[i+2],p[i+1]));
	}
	
	cout << n << " " << edges.size() << "\n";
	for(auto&[x,y] : edges){
		cout << x+1 << " " << y+1 << "\n";
	}
 
	return 0;
}
