#ifndef LOCAL
#pragma GCC optimize("O3,unroll-loops")
#pragma GCC target("avx2,bmi,bmi2,lzcnt,popcnt")
#endif

#include <bits/stdc++.h>
using namespace std;

using VI = vector<int>;
using Gr = vector<vector<int>>;

#define fast ios_base::sync_with_stdio(0); cin.tie(nullptr); cout.tie(nullptr);

#define CR const&

bool DFS(int u, VI& color, Gr CR G, int c = 0) {
    if(color[u] != -1)
        return color[u] == c;
    color[u] = c;

    for(auto v : G[u])
        if(!DFS(v, color, G, !c))
            return false;
    return true;
}

bool check_bipartite(Gr CR G) {
    int n = G.size();
    VI color(n, -1);
    for(int i = 0; i < n; ++i)
        if(color[i] == -1 && !DFS(i, color, G))
            return false;
    return true;
}

int main() {
    fast

    int n, m;
    cin >> n >> m;

    vector<pair<int, int>> a(m);
    for(auto& [u, v] : a) {
        cin >> u >> v;
        --u;
        --v;
    }

    int ans = 1;
    Gr G(n);
    for(auto [u, v] : a) {
        G[u].push_back(v);
        G[v].push_back(u);

        if(!check_bipartite(G)) {
            G = Gr(n);
            G[u].push_back(v);
            G[v].push_back(u);
            ++ans;
        }
    }

    cout << ans << "\n";
}
