#include <iostream>
#include <algorithm>
#include <iomanip>
#include <random>
#include <string.h>

using namespace std;

constexpr int N = (int)1e6+111;

struct DSU{
    int p[N];
    int deep[N];
    int col[N];
    DSU(){
        for(int i = 0; i < N; i++){
            p[i] = i;
            deep[i] = 0;
            col[i] = 0;
        }
    }
    int get(int x){
        if(p[x] == x)
            return x;
        if(p[p[x]] = p[x])
            return p[x];
        int c = get(p[x]);
        col[x] ^= col[c];
        p[x] = c;
        return p[x];
    }
    void union_sets(int a,int b){
        get(a);
        get(b);
        int c1 = col[a], c2 = col[b];
        a = get(a), b = get(b);
        if(a == b)
            return;
        if(deep[a] > deep[b])
            swap(a,b);
        deep[b] += deep[a] == deep[b];
        col[a] = 1^c1^c2;
        p[a] = b;
        return;
    }
    bool can(int a,int b){
        get(a),get(b);
        return get(a) != get(b) || col[a] != col[b];
    }
} d;

int main(){
    ios::sync_with_stdio(false);cin.tie(nullptr);cout.tie(nullptr);
    
    int n,m;
    cin >> n >> m;

    int a[m],b[m];
    for(int i = 0; i < m; i++){
        cin >> a[i] >> b[i];
    }

    int ans = 1;
    int l = 0;
    for(int i = 0; i < m; i++){
        if(!d.can(a[i],b[i])){
            for(int j = l; j < i; j++){
                d.p[a[j]] = a[j];
                d.p[b[j]] = b[j];
                d.deep[a[j]] = 0;
                d.deep[b[j]] = 0;
                d.col[a[j]] = 0;
                d.col[b[j]] = 0;
            }
            l = i;
            ans++;
        }
        d.union_sets(a[i],b[i]);
    }

    cout << ans << "\n";

    return 0;
}