#include "testlib.h"
#include <iostream>
#include <vector>
#include <algorithm>
#include <queue>

// #include <ext/pb_ds/tree_policy.hpp>
// #include <ext/pb_ds/assoc_container.hpp>
 
// constexpr int MAX_N = 1'000'000;
// constexpr int MAX_A = (int)1e9;

using namespace std;

constexpr int N_MAX = (int)5e5;
constexpr int Q_MAX = (int)5e5;
constexpr int A_MAX = (int)1e7;

constexpr int TOTAL_GAMES = 19683;

int power[] = {1,3,9,27,81,243,729,2187,6561};
 
int getOrder(int x,int y){
      return (x-1)*3+y-1;
}
 
int getValue(int state,int x,int y){
      return state / power[getOrder(x,y)] % 3;
}
 
bool checkLegalMove(int state,int x,int y){
      return x >= 1 && x <= 3 && y >= 1 && y <= 3 && getValue(state,x,y) == 0;
}
 
void setState(int& state,int x,int y,int val){
      state = state - getValue(state,x,y) * power[getOrder(x,y)] + val * power[getOrder(x,y)];
      return;
}
 
int isWin(int state){
      int matrix[3][3];
      for(int i = 0; i < 3; i++){
              for(int j = 0; j < 3; j++){
                      matrix[i][j] = state % 3;
                      state /= 3;
              }
      }
      for(int val = 1; val <= 2; val++){
              for(int i = 0; i < 3; i++){
                      if(matrix[i][0] == val && matrix[i][1] == val && matrix[i][2] == val){
                              return val;
                      }
              }
              for(int j = 0; j < 3; j++){
                      if(matrix[0][j] == val && matrix[1][j] == val && matrix[2][j] == val){
                              return val;
                      }
              }
              if(matrix[0][0] == val && matrix[1][1] == val && matrix[2][2] == val){
                      return val;
              }
              if(matrix[0][2] == val && matrix[1][1] == val && matrix[2][0] == val){
                      return val;
              }
      }
      return 0;
}
 
int isDraw(int state){
      int w = isWin(state);
      int matrix[3][3];
      bool gameFinished = true;
      for(int i = 0; i < 3; i++){
              for(int j = 0; j < 3; j++){
                      matrix[i][j] = state % 3;
                      state /= 3;
                      gameFinished &= matrix[i][j] > 0;
              }
      }
      if(gameFinished && !w)
              return 1;
      return 0;
}
 
char convert(int x){
      return x == 0 ? '.' : (x == 1 ? 'X' : '0');
}
 
void printGameState(int state){
      int matrix[3][3];
      for(int i = 0; i < 3; i++){
              for(int j = 0; j < 3; j++){
                      matrix[i][j] = state % 3;
                      state /= 3;
              }
      }
      for(int i = 0; i < 3; i++){
              for(int j = 0; j < 3; j++){
                      cout << convert(matrix[i][j]);
              }
              cout << "\n";
      }
      return;
}
 
pair<int,int> best_move[TOTAL_GAMES]; /// 3^9
int win[TOTAL_GAMES];
std::vector<pair<int,int>> possible_tables;
 
int simulate(int state,int turn){
      if(win[state] != -1)
              return win[state];
      possible_tables.push_back(make_pair(state,turn));
      if(isWin(state))
              return win[state] = isWin(state);
      if(isDraw(state))
              return win[state] = 0;
      bool winning = false;
      bool draw = false;
      for(int i = 1; i <= 3; i++){
              for(int j = 1; j <= 3; j++){
                      if(checkLegalMove(state,i,j) == false)
                              continue;
                      int new_state = state;
                      setState(new_state,i,j,turn);
                      int res = simulate(new_state,turn^3);
                      if(res == turn){
                              winning = true;
                              best_move[state] = make_pair(i,j);
                      }
                      if(res == 0){
                              draw = true;
                              if(!winning)
                                      best_move[state] = make_pair(i,j);
                      }
              }
      }
      win[state] = (winning ? turn : (draw ? 0 : turn^3));
      return win[state];
}
 
void simulateGames(){
      for(int i = 0; i < TOTAL_GAMES; i++){
              win[i] = -1;
      }
      simulate(0,1);
      return;
}

signed main(int argc,char* argv[]){
	registerGen(argc,argv,1);
 
	simulateGames();

	sort(possible_tables.begin(),possible_tables.end());

	int sz = possible_tables.size();
	int pos = rnd.next(0,sz-1);

	int state = possible_tables[pos].first;
	int turn = possible_tables[pos].second;
	printGameState(state);

	bool nextlegalmove = (isWin(state) || isDraw(state) ? false : true);
	if(nextlegalmove){
		vector<int> nxt;
		for(int i = 1; i <= 3; i++){
              for(int j = 1; j <= 3; j++){
                      if(checkLegalMove(state,i,j) == false)
                              continue;
                      int new_state = state;
                      setState(new_state,i,j,turn);
                      nxt.push_back(new_state);
              }
      	}
      	int j = rnd.next(0,(int)nxt.size()-1);
      	printGameState(nxt[j]);
	} else {
		bool rndstate = (rnd.next(0,10) < 8 && state > 0 ? true : false);
		if(rndstate){
			int j = rnd.next(0,sz-1);
			printGameState(possible_tables[j].first);
		} else {
			vector<int> nxt;
			for(int i = 1; i <= 3; i++){
              for(int j = 1; j <= 3; j++){
                      if(getValue(state,i,j) == (turn^3))
                              continue;
                      int new_state = state;
                      setState(new_state,i,j,0);
                      nxt.push_back(new_state);
              }
      		}
      		int j = rnd.next(0,(int)nxt.size()-1);
      		printGameState(nxt[j]);
		}
	}

	return 0;
}