#include <iostream>
#include <algorithm>
#include <vector>

using namespace std;

constexpr int k = 3;

int main(){
    ios::sync_with_stdio(false);cin.tie(nullptr);cout.tie(nullptr);

    char A[k][k];
    for(int i = 0; i < k; i++){
        for(int j = 0; j < k; j++){
            cin >> A[i][j];
        }
    }

    char B[k][k];
    for(int i = 0; i < k; i++){
        for(int j = 0; j < k; j++){
            cin >> B[i][j];
        }
    }

    vector<pair<int,int>> diff;
    for(int i = 0; i < k; i++){
        for(int j = 0; j < k; j++){
            if(A[i][j] != B[i][j])
                diff.push_back(make_pair(i,j));
        }
    }

    if(diff.size() > 1){
        cout << "NO\n";
        return 0;
    }

    if(diff.size() == 0){
        cout << "YES\n";
        return 0;
    }

    auto[x,y] = diff[0];
    if(A[x][y] != '.'){
        cout << "NO\n";
        return 0;
    }

    int diffA = 0;
    for(int i = 0; i < k; i++){
        for(int j = 0; j < k; j++){
            if(A[i][j] == 'X')
                diffA++;
            else if(A[i][j] == '0')
                diffA--;
        }
    }

    if(diffA == 0){
        if(B[x][y] != 'X'){
            cout << "NO\n";
            return 0;
        }
    } else {
        if(B[x][y] != '0'){
            cout << "NO\n";
            return 0;
        }
    }

    cout << "YES\n";

    return 0;
}