#ifndef LOCAL
#pragma GCC optimize("O3,unroll-loops")
#pragma GCC target("avx2,bmi,bmi2,lzcnt,popcnt")
#endif

#include <bits/stdc++.h>

using namespace std;

class DSU {
    struct T {
        int p = -1, r = 0;
        int x = 0; //link parity
    };
    vector<T> a;
    vector<int> hist;
public:
    DSU(int n) : a(n) {}

    void clear() {
        for(auto u : hist)
            a[u] = T{};
        hist.clear();
    }

    pair<int, int> get(int u) { //parent, actual h
        if(a[u].p == -1)
            return {u, 0};

        auto [v, x] = get(a[u].p);
        a[u].p = v;
        a[u].x ^= x;
        return {a[u].p, a[u].x};
    }

    bool unite(int u, int v) {
        auto [pu, cu] = get(u);
        auto [pv, cv] = get(v);
//        print(u, pu, cu, v, pv, cv);

        if(pu == pv)
            return cu != cv;

        if(a[u].r == a[v].r)
            ++a[u].r;
        else if(a[u].r < a[v].r) {
            swap(u, v);
            swap(pu, pv);
            swap(cu, cv);
        }

//        print(pv, "->", u);

        a[pv].p = u;
        a[pv].x = cv ^ 1;
        hist.push_back(pv);

        return true;
    }
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

    int n, m;
    cin >> n >> m;

    vector<pair<int, int>> a(m);
    for(auto& [u, v] : a) {
        cin >> u >> v;
        --u;
        --v;
    }

    DSU dsu(n);

    int ans = 1;
    for(auto [l, r] : a) {
        if(!dsu.unite(l, r)) {
            dsu.clear();
            dsu.unite(l, r);
            ++ans;
        }
    }
    cout << ans << "\n";
}
